package kimiko.japonais.app.data.ui;

import kimiko.japonais.app.R;
import android.content.Context;
import android.database.Cursor;
import android.os.Bundle;
import android.support.v4.widget.CursorAdapter;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

public class MotAdapter extends CursorAdapter {

	public MotAdapter(Context context, Cursor cursor) {
		super(context, cursor, true);
	}

	private class ViewHolder {
		TextView wordJaponais, wordKana, wordRom, wordTrad;
	}
	
	@Override
	public void bindView(View view, Context context, final Cursor cursor) {
		ViewHolder holder = new ViewHolder();
		holder.wordJaponais = (TextView)view.findViewById(R.id.wordJaponais);
		holder.wordTrad = (TextView)view.findViewById(R.id.wordTrad);
		holder.wordKana = (TextView)view.findViewById(R.id.wordKana);
		holder.wordRom = (TextView)view.findViewById(R.id.wordRom);
		view.setTag(holder);

		holder.wordJaponais.setText(cursor.getString(1));
		holder.wordKana.setText(cursor.getString(2));
		holder.wordRom.setText(cursor.getString(3));
		holder.wordTrad.setText(cursor.getString(4));
		view.setOnLongClickListener(new CopierListener(context, cursor.getString(1)));
		
		Bundle bundle = new Bundle();
		bundle.putString("jap", cursor.getString(1));
		bundle.putString("kana", cursor.getString(3));
		bundle.putString("rom", cursor.getString(2));
		bundle.putString("trad", cursor.getString(4));
		view.setOnClickListener(new DetailListener(context, bundle));
	}


	@Override
	public View newView(Context context, final Cursor cursor, ViewGroup viewGroup) {
		ViewHolder holder = new ViewHolder();
		LayoutInflater inflater = LayoutInflater.from(context);
		View view = inflater.inflate(R.layout.mot, null);
		holder.wordJaponais = (TextView)view.findViewById(R.id.wordJaponais);
		holder.wordTrad = (TextView)view.findViewById(R.id.wordTrad);
		holder.wordKana = (TextView)view.findViewById(R.id.wordKana);
		holder.wordRom = (TextView)view.findViewById(R.id.wordRom);
		view.setTag(holder);

		holder.wordJaponais.setText(cursor.getString(1));
		holder.wordKana.setText(cursor.getString(2));
		holder.wordRom.setText(cursor.getString(3));
		holder.wordTrad.setText(cursor.getString(4));
		view.setOnLongClickListener(new CopierListener(context, cursor.getString(1)));
		
		Bundle bundle = new Bundle();
		bundle.putString("jap", cursor.getString(1));
		bundle.putString("kana", cursor.getString(3));
		bundle.putString("rom", cursor.getString(2));
		bundle.putString("trad", cursor.getString(4));
		view.setOnClickListener(new DetailListener(context, bundle));
		

		return view;
	}
}
