package kimiko.japonais.app.fragment;

import java.util.Locale;

import kimiko.japonais.app.R;
import kimiko.japonais.app.data.ExempleDAO;
import kimiko.japonais.app.data.ui.CopierListener;
import kimiko.japonais.app.data.ui.ExampleAdapter;

import android.content.Intent;
import android.database.Cursor;
import android.os.Bundle;
import android.speech.tts.TextToSpeech;
import android.speech.tts.TextToSpeech.OnInitListener;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.View.OnClickListener;
import android.widget.ImageButton;
import android.widget.ListView;
import android.widget.TextView;

public class MotFragment extends DetailFragment implements OnInitListener {
	private String tradText, japText;
	private TextView japonais, kana, trad, rom;
	private ImageButton lecture;
	
	@Override
	public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
		View view = inflater.inflate(R.layout.fragment_mot, container, false);
		setHasOptionsMenu(true);
		
		this.tts = new TextToSpeech(this.getActivity(), this);
		this.tts.setSpeechRate(0.8f);
		
		Bundle b = this.getActivity().getIntent().getExtras();
		if(b==null)
			b = getArguments();
		
		this.tradText = b.getString("trad");
		this.japText = b.getString("japonais");
		
		this.japonais = ((TextView)view.findViewById(R.id.japonais));
		this.kana = ((TextView)view.findViewById(R.id.kana));
		this.trad = ((TextView)view.findViewById(R.id.trad));
		this.rom = ((TextView)view.findViewById(R.id.rom));
		
		this.lecture = ((ImageButton)view.findViewById(R.id.lecture));
		this.lecture.setAlpha(0.5f);
		ListView listView = (ListView) view.findViewById(R.id.exemples);
		
		this.japonais.setText(b.getString("jap"));
		this.kana.setText(b.getString("rom"));
		this.trad.setText(b.getString("trad"));
		this.rom.setText(b.getString("kana"));
		
		this.japonais.setOnLongClickListener(new CopierListener(this.getActivity(), b.getString("jap")));
		this.kana.setOnLongClickListener(new CopierListener(this.getActivity(), b.getString("rom")));
		this.trad.setOnLongClickListener(new CopierListener(this.getActivity(), b.getString("trad")));
		this.rom.setOnLongClickListener(new CopierListener(this.getActivity(), b.getString("kana")));
		
		ExempleDAO exempleDAO = new ExempleDAO(this.getActivity());
		exempleDAO.open();
		Cursor exemples = exempleDAO.chercher(b.getString("jap"));
		ExampleAdapter adapter = new ExampleAdapter(this.getActivity(), exemples);
		listView.setAdapter(adapter);
		exempleDAO.close();
		
		return view;
	}

	@Override
	public void onInit(int status) {
		if (status == TextToSpeech.SUCCESS) {
			int result = TextToSpeech.LANG_MISSING_DATA;
			if(Locale.getDefault().equals(Locale.JAPAN)||Locale.getDefault().equals(Locale.JAPANESE))
			{
				Locale loc = new Locale("fra", "FRA");
				result = tts.setLanguage(loc);
			}
			else
			{
				result = tts.setLanguage(Locale.JAPAN);
			}
			if (result == TextToSpeech.LANG_MISSING_DATA || result == TextToSpeech.LANG_NOT_SUPPORTED) {
				Log.e("TTS", "This Language is not supported");
				this.ttsSupported=false;
			}
			this.lecture.setOnClickListener(new OnClickListener() {
				@Override
				public void onClick(View v) {
					if(!ttsSupported)
					{
						Intent installIntent = new Intent();
						installIntent.setAction(TextToSpeech.Engine.ACTION_INSTALL_TTS_DATA);
						startActivity(installIntent);
					}
					
					if(Locale.getDefault().equals(Locale.JAPAN)||Locale.getDefault().equals(Locale.JAPANESE))
						tts.speak(tradText, TextToSpeech.QUEUE_FLUSH, null);
					else
						tts.speak(japText, TextToSpeech.QUEUE_FLUSH, null);
				}
			});
			this.lecture.setAlpha(1f);
		} else {
			Log.e("TTS", "Initilization Failed!");
		}
	}
	
	@Override
	public void onDestroy() {
		this.tts.shutdown();
		super.onDestroy();
	}

}
