package kimiko.japonais.app.fragment;

import kimiko.japonais.app.R;
import kimiko.japonais.app.data.MotDAO;
import android.app.SearchManager;
import android.database.Cursor;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.View.OnTouchListener;
import android.view.ViewGroup;
import android.widget.CursorAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.SearchView;

public abstract class SearchFragment extends Fragment {
	protected ListView listView;
	protected ListAdapter adapter;
	protected SearchView searchView;

	@Override
	public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
		View view = inflater.inflate(R.layout.search_fragment, container, false);
		setHasOptionsMenu(true);
		
		this.listView = (ListView) view.findViewById(R.id.mots);
		return view;
	}
	
	public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState, int searchFragment) {
		View view = inflater.inflate(searchFragment, container, false);
		setHasOptionsMenu(true);
		
		this.listView = (ListView) view.findViewById(R.id.mots);
		return view;
	}

	@Override
	public void onCreateOptionsMenu(Menu menu, MenuInflater inflater) {
		super.onCreateOptionsMenu(menu, inflater);
		this.searchView = (SearchView) menu.findItem(R.id.menu_rechercher).getActionView();
		
		searchView.setOnClickListener(new OnClickListener(){

			@Override
			public void onClick(View v) {
				Log.v("SearchFragment", "onclick");
				MotDAO motDAO = new MotDAO(getActivity());
				motDAO.open();
				motDAO.close();
			}});
		searchView.setOnTouchListener(new OnTouchListener(){

			@Override
			public boolean onTouch(View v, MotionEvent event) {
				Log.v("SearchFragment", "onTouch");
				MotDAO motDAO = new MotDAO(getActivity());
				motDAO.open();
				motDAO.close();
				return false;
			}});
		
		searchView.setOnSuggestionListener(new SearchView.OnSuggestionListener() {
	        @Override
	        public boolean onSuggestionSelect(int position) {
	            return true;
	        }

	        @Override
	        public boolean onSuggestionClick(int position) {
	            CursorAdapter selectedView = searchView.getSuggestionsAdapter();
	            Cursor cursor = (Cursor) selectedView.getItem(position);
	            int index = cursor.getColumnIndexOrThrow(SearchManager.SUGGEST_COLUMN_INTENT_DATA);
	            searchView.setQuery(cursor.getString(index), true);
	            return true;
	        }
	    });
	}
	
	public abstract void chercher(String entree);

}
